## Production Server

### Identification

The server requires and API key and OAuth AccessToken in order to access any of the FHIR service resources. Please refer to the [Guidance --> Process to request API Key](guidance.html#process-to-request-api-key-and-oauth-credentials)

#### API Key
Your API key must be provided as per below when invoking any NHSD FHIR resource request.

As part of the HTTP Header the request should contain a header with name *x-api-key* and the value is your api key.


### Authentication
An OAuth 2.0 Bearer Token (an AccessToken) is required to access NHSD FHIR resources.

#### OAuth
The Bearer token will be obtained through a standard OAuth 2 - Client Credential Grant process. Refer to <a target="_blank" href="https://www.oauth.com/oauth2-servers/access-tokens/client-credentials/">CLIENT CREDENTIAL</a> grant type.

The NHSD FHIR Service require both an API-key and an Authentication-Context (Bearer Token). The API-key is used to ensure quality of service in the form of rate-limiting and is not to be confused with the OAuth AccessToken.

**STEP 1: OBTAIN TOKEN**
```
POST /iam/oauth/token  HTTP/1.1
Host: {shall be provided}.nhsd.healthdirect.org.au
x-api-key: (API KEY AS PROVIDED BY NHSD)
Cache-Control: no-cache
****************************************************
BODY "application/x-www-form-urlencoded" encoded
with PAYLOAD as below:
grant_type = client_credentials
client_id = the provided username
client_secret = the provided secret/password
****************************************************
```

**STEP 2: RECEIVE TOKEN RESPONSE**

The Response will issue you with 2 tokens - the accessToken is the be added in all subsequent API-calls as the Authorization header. **Please note that an AccessToken is only valid for 1 hour from time of issue. Refresh tokens are valid for approx 7 days, however this time may be adjusted without prior notice.**
```
{
    "accessToken": "eyJraWQiOiJVbWZ0TUhaQWJHUEd4OUJXVVU1VnREXC80UEIxcUpmM2JueDhyM251YjZmOD0iLCJhbGciOiJSUzI1NiJ9.eyJzdWIiOiIzZWQyODlkMC02NDRmLTQzMDAtYjE0Ny1mNGEzYzExMTc3NmUiLCJjb2duaXRvOmdyb3VwcyI6WyJPcmFjbGUiXSwiZXZlbnRfaWQiOiIxODIyZWVlOS1hNWJiLTExZTgtOGIwYS0xMzJiYjgzNGE4NGIiLCJ0b2tlbl91c2UiOiJhY2Nlc3MiLCJzY29wZSI6ImF3cy5jb2duaXRvLnNpZ25pbi51c2VyLmFkbWluIiwiYXV0aF90aW1lIjoxNTM0OTA4MzYxLCJpc3MiOiJodHRwczpcL1wvY29nbml0by1pZHAuYXAtc291dGhlYXN0LTIuYW1hem9uYXdzLmNvbVwvYXAtc291dGhlYXN0LTJfUzkyNXVueTFYIiwiZXhwIjoxNTM0OTExOTYxLCJpYXQiOjE1MzQ5MDgzNjEsImp0aSI6ImU0YjA5ZDNiLTJmNTQtNDczYy1hYzFlLWYzZjhjMTFiMzU4OCIsImNsaWVudF9pZCI6InVhMWNtZGhnaTI2bDNmbDU1cTVmbHQ0aXYiLCJ1c2VybmFtZSI6ImxhcnJ5ZWxsaXNvbiJ9.kJTMPLcv5fpj8g9dB_kwPCgMdK8VKKULk5yWUbBKzE8Tc5OTvNJ_3hxMj7DFZRO2oRorRqVZqvvLaFARwDuz1Kly7Qet8Y1mKuAipGlibzFocZ6V_bIg4vkj6a_uqNcN6h7qFJOAPByptTLIu-nWuMktM2NZVMUCZgvpLGLUg7dN9PO68AkEeWX5A58jGOqyDQ09-J-lYZUjpUKb0whzWVjvj9O66MlOsceoGDoyMrY777iHx4mUC2yp7tfSO3_i2k90fYIELwFs6adgW5c7rDRbK_WKTajbwFVY1JBj5GDaiTSdH2q_hfAElvZAb4r1AfhFTa1jsWa5LcowaA3DQg",
    "refreshToken": "eyJjdHkiOiJKV1QiLCJlbmMiOiJBMjU2R0NNIiwiYWxnIjoiUlNBLU9BRVAifQ.ewnGfLhdXtfWm4S0o9nWKCIK1eGDxKNkHIiESVK2aa16ieghnb8O6iiYf7jyK2R3AxPDNzIMo3s3gaBS6S-8qbKB-xNJqKDfZRqqvnBVQSx9rrvId2eZNdUP1FJUQd3leq4UsdVAgqfYp9Q0gbZ-6kScN6uw983qAJ1VisBkClzPTUbdje13nF7VLB7omFbpiBku_3gr9UXQzUhZtSHXQyJymC236b2A9YpUnDGCJQc-6cmR4uu2HG_424GsGDO7V2JLHtdPULcdma8oR4SjgVdn5ToqMeMN3Sdp01bwqpTHmiDUGMkQi1B22--FkGKpeCJQzvAf0M0dvdgFUu6AyA.WTexVYmQGqEINaPx.myxQfx2yaSTchA1q6WFASsSBritFF8xf1aeYaK-kEAm_TwZpw2RR9cWQRb34eOoKju25PYeJ06x4APkh9U3-FjaZBum3IJEZ5eyly-bUF0nbxGIa1hfy0nS_s7WGRVWWz7i12MKQr8cqvUwI4oz0WyGWAnA3HQhBhXWqgTaWO4glUAdUHVHI6BHXP8PpXw8zSbiPiJJhC5IQtpm-8OVWxsAj1toLlcXL2nPw0W3BrAEeb8ThzmvNEuNxExnqEWJ8nAtbjSdeVpBtSC_zznSiG6dIImDq8tngCSYJ5MFda5D09UDGQRnmTpCdnjgWIoDnOeIBvsBvy_DWxHGsjGsDdKKt667HMgOKfZQeEmWVNI61bnLK_jzveJ1tztO1cYp1EyHf-s8PnFwzfHUDFdjtXu1dk852F3YOoCbZk5-46ZP20TLQKONeBm7ukgi7nzxSQlCrpFt6fVXVDMjiTbd_ap6S1lY0OH-SI9TLB7nzMiPs5ptTUStjSjDLlIfvzO4ltLFDjq53SLG-8z4GFps-SODKZqP_TaKTpZcWz041savqC2i22s2E7bZ-t4FRMAPmnIBvpTFLPN3UbmATaJSgVdKuUIMYOfidiTE4tsJsCRm9Z9E9tOtzJv4rnY8p5MuUglNpV1dWlOFZ6aWmC1N_L1kKVpcuLctxYCRVqkcX8JIdwVzXovDOmu6DjtTJM7ehG7zUgegBRIFCpXcVcUYtU73ogUZWEYrjIz8TkwlSweFVR-zxgeLorsvbXcBh4xd59rePq0mDNRcmqveHBFMTEWgjw8jTpkG4BKGabcag8xZJIwCDxUK-nO-B2-JqvstiV_wWhbv5qOsXsulpUUFrD7rEZHUSytA4_XteEyl9rBfROddTb_ebi9EGVj6INXBmlcJ-DYfvPFAgxoFBnGzai2J3FhF6-Gneax32RBWE-iapO5J7K-IdNPHKKVjIcUEP2F_6zKxWzBhLemdtTdhq55hv2ayzMdhRNQKpWi2Kcxl3Zt-Qz3kQ_J0_foLvy2LarWHa6-orY5bzh8yfWIQTrS9fcQjVhieCE6xtKX2hv2aI6PbC1L5XmI-zr7VQP7l9soKof_c1x6-HAfqIP7zatuzcsBaBXMMkA9y6Y7B-7D1I70f78kAr80i2em3EwGg_YQNhH3iHpsu7kWY4ortYuueWIX0XTAb6kIW-I-T7NKPG3Sg-UQe1rYsQXH5FckUI4h3YGvQBo-93AeFDAlUbVzOIoUP3Nrwghwi7oESgxMRr4JpOdmdQZjbwdguvQucGN3WeUpX1-OUh2ToDkOjQqJppyBPVknw.odqgL-gQiSHqn3Rdeemg9Q"
}
```

**STEP 3: ISSUE an AUTHENTICATED API CALL**
* required : x-api-key
* required : Authorization
* required : Content-Type
```
GET /v4/HealthcareService/9a5d6f34-698c-37f1-1475-bdcae0496502 HTTP/1.1
Host: api.fhir.nhsd.healthdirect.org.au
x-api-key: (API KEY AS PROVIDED BY NHSD)
Authorization: Bearer eyJraWQiOiJVbWZ0TUhaQWJHUEd4OUJXVVU1VnREXC80UEIxcUpmM2JueDhyM251YjZmOD0iLCJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJhNGY2MmFmYS00ZDc4LTQxNjQtOGVlYS1iZTRlNTA4N2FiZWYiLCJjb2duaXRvOmdyb3VwcyI6WyJQVUJMSUNfTElNSVRFRCJdLCJldmVudF9pZCI6Ijc2MmY1ZTA4LWFjZDQtMTFlOC1hNGM1LTNiMDE2ZjMxMjE1OCIsInRva2VuX3VzZSI6ImFjY2VzcyIsInNjb3BlIjoiYXdzLmNvZ25pdG8uc2lnbmluLnVzZXIuYWRtaW4iLCJhdXRoX3RpbWUiOjE1MzU2ODg5MTUsImlzcyI6Imh0dHBzOlwvXC9jb2duaXRvLWlkcC5hcC1zb3V0aGVhc3QtMi5hbWF6b25hd3MuY29tXC9hcC1zb3V0aGVhc3QtMl9TOTI1dW55MVgiLCJleHAiOjE1MzU2OTI1MTUsImlhdCI6MTUzNTY4ODkxNSwianRpIjoiMWEwMjkyMzMtZDI3OS00MWFmLTlhYmItN2ViN2Q2NTcyYWE2IiwiY2xpZW50X2lkIjoidWExY21kaGdpMjZsM2ZsNTVxNWZsdDRpdiIsInVzZXJuYW1lIjoidXNlcjEwMyJ9.LOE4cQLFmzc68hmt27JwoGlOsTX6Sa0uNCX7Tq_mSuitwZd0B369KBBA4Z9NrElTPWefrUj60UCMeTmZnhZxenCqiCBJqZSoyvryxdk3IZoucBC7lhdFqLKrT7apiAKb8P-VEDDWSm_zyYDAJ8XV-EBtTxDuB08Uc3cju2q29v_np4g3sVAscfTXAVBXERuzQ6pVLOe4BI8sGHqXEOAr4LTMOmiGvE3LYTZgIxFvr7j2qUr5hONzZHxzzixG8WimjnJZouqoXQxIlKt8T6WfJxRmAczRebjBxHDRwgxiv0KQC85671JYx9ZMf8dZRuqESiXw0dCYHA_pqHmBlPiwuw
Content-Type: application/json
Cache-Control: no-cache
```


#### Client Certificate or Mutual Authentication
Client Certificate or Mutual Authentication is not supported as at April 2019.




