
### Introduction
This guide is provided to support the use of FHIR<sup>&reg;&copy;</sup> in an Australian context within the National Health Services Directory (NHSD). The guide aims to assist clients who wish to integrate with the FHIR Server offered by the National Health Services Directory.

For more information, including how to request access to the NHSD FHIR Server, please refer to the [general guidance](guidance.html) section.

Please note that minor extensions have been made to the Provider Directory Profiles, however these extensions are considered specific to the National Health Services Directory at this time. As the FHIR specification is adopted and finalised within the Australian Health IT sector, extensions may be adopted by parent profiles or included within the International profile.

### Scope

The following profiles are managed through the National Health Services Directory:

* [NHSD HealthcareService](StructureDefinition-nhsd-healthcareservice.html)
* [NHSD Organization](StructureDefinition-nhsd-organisation.html)
* [NHSD Location](StructureDefinition-nhsd-location.html)
* [NHSD Practitioner](StructureDefinition-nhsd-practitioner.html)
* [NHSD Practitioner Role](StructureDefinition-nhsd-practitionerrole.html)
* [NHSD Endpoint](StructureDefinition-nhsd-endpoint.html)
* [NHSD Bulk Exports](bulkexports.html)

Most of the resource profiles defined above have not had extensions defined.

### Usage

Although the National Health Services Directory aims to ensure accuracy of information published within this implementation guide, it should be noted that the definitions herein is generated from the base profiles and that extensions and structures are still evolving.
This implementation guide is not developed or published to support further extensions. The guide is published to provide implementers a comprehensive online set of documentation, within the same format as the official base FHIR guides (local and international).

Should you wish to develop your own FHIR Server and manage custom extensions, please extend your profiles from the Australian Base or Australian Provider Directory profiles. It is recommended to discuss your requirements with HL7 Australia before doing so.

### Collaboration

The guide and base profiles is the product of collaborative work undertaken with participants from:

* National Health Services Directory
* <a target="_blank" title="Provider Directory Technical Working Group" href="http://build.fhir.org/ig/hl7au/au-fhir-pd/index.html">Provider Directory Technical Working Group</a>
* <a target="_blank" title="Patient Administration Technical Working Group" href="http://build.fhir.org/ig/hl7au/au-fhir-base/index.html">Patient Administration Technical Working Group</a>
* Australian Digital Health Agency
* Australian FHIR Implementers’ Community
* HL7 Australia Members