{:.no_toc}

<!-- TOC -->

* Do not remove this line (it will not be displayed)
{:toc}

## Server Access
The National Health Services Directory production environment is deployed on the domain: https://api.fhir.nhsd.healthdirect.org.au/v4

```
The production server require the following authentication credentials:
* an API-key
* a Bearer Token (AccessToken obtained though an OAuth Client-Credential grant process)
```

Please refer to the [security](security.html) section for technical connection details.

#### Process to request API Key and OAuth Credentials
---------------
Submit an application for registration and access to the NHSD Test/Production environment, please submit the request via the NHSD Developer and Integration Hub: https://about.healthdirect.gov.au/nhsd/developer-and-integration-hub/getting-started

---------------

### Known defects or non-supported features:
The following are known areas of functions that are not supported or earmarked to be addressed in future releases.

#### Search
* Search HealthcareService.specialty is not supported

#### Paging
* No support for the previous / next relation links. Should you wish to page to the next, issue a subsequent query with the appropriate **page=000** request parameter. See [capability statement](capstatements.html) for more information.

#### Client Certificate or Mutual Authentication
Client Certificate or Mutual Authentication is not supported as at October 2020.


## General FHIR references and Implementation Notes
Please note, that not all of the FHIR specification search behaviours have been implemented. Where possible, these have been noted throughout this implementation guide.
* [(how to search by reference)]
* [(how to search by token)]
* [(how to search by date)]
* [(how to search by string)]
* [(how to search by quantity)]
* [(how to read resource)]

## Questions or Feedback?

If you need further information or have any questions or feedback, please contact the NHSD team on nhsd [at] healthdirect.org.au


 [(how to search by reference)]: http://hl7.org/fhir/search.html#reference
 [(how to search by token)]: http://hl7.org/fhir/search.html#token
 [(how to search by date)]: http://hl7.org/fhir/search.html#date
 [(how to search by string)]: http://hl7.org/fhir/search.html#string
 [(how to search by quantity)]: http://hl7.org/fhir/search.html#quantity
 [(how to read resource)]: http://hl7.org/fhir/http.html#read
