

## Scope of Resource Profiles

National Health Services Directory (NHSD) FHIR resource types that are supported is documented in this specification.

* **Location** is physical location, where service delivery occurs.
* **Organization** is an entity providing practitioner roles and/or healthcare service.
* **PractitionerRole** (provider) is a practitioner acting roles at a particular location for an organisation.
* **Practitioner** details of an individual that maybe acting in a practitioner role.
* **HealthcareService** describes the services delivered at one location for one organisation.
* **Endpoint** provides details of an endpoint for addressing a Secure message delivery.


## Service Interactions Overview

FHIR interactions that are supported by NHSD.

----------
### Instance Level Interactions

* **[read](http://hl7.org/fhir/STU3/http.html#read)** PractitionerRole, Practitioner, HealthcareService, Location, Organization, Endpoint

----------
### Type Level Interactions

* **[search](http://hl7.org/fhir/STU3/http.html#search)** PractitionerRole, Practitioner, HealthcareService, Organization

----------
### Whole System Interactions

*Headers*
* *x-request-id* auto generated and may be injected for tracing.


----------
### Type Level Search

<span style='color:red'>**IMPORTANT NOTE:** The NHSD FHIR Server require/recommend an HTTP **POST-method** for complex search behaviours under the following circumstances:</span>
* the URL-length is approx 4,000 characters
* should you not be entirely sure what level of complexity could be added to the URLs - rather implement POST as default

A **POST** search require the endpoint to be modified to **_search** as follows:
```
POST [base]/HealthcareService/_search{}
Host: {as per documentation}.nhsd.healthdirect.org.au
x-api-key: {API KEY AS PROVIDED BY NHSD}
Content-Type: application/x-www-form-urlencoded
_id=9680fa57-554e-68a1-839a-63d44e501802&_include=HealthcareService%3Alocation&_include=HealthcareService%3Aorganization
```
```
POST [base]/HealthcareService/_search HTTP/1.1
Host: {as per documentation}.nhsd.healthdirect.org.au
x-api-key: {API KEY AS PROVIDED BY NHSD}
Content-Type: application/x-www-form-urlencoded
_count=5&characteristic=http%3A%2F%2Fnhsd.healthdirect.org.au%2FCodeSystem%2Frc-program%7CnpepProgram&characteristic=http%3A%2F%2Ffhir.nhsd.com.au%2FCodeSystem%2Frc-providerLocationServiceCharacteristic%7CmyHealthRecord
```

The following attributes are supported within the search scope:

|Resource Type|Profile|Search Parameters|Includes|
|---|---|---|---|
|[Organization](StructureDefinition-nhsd-healthcareservice.html#search)| Organisation Directory Entry | **Basic Attributes:** _id, name, identifier **Organization:** partof (as reference) **Paging Support:** page, _count ||
|[HealthcareService](StructureDefinition-nhsd-healthcareservice.html#search)| HealthcareService Directory Entry | **Basic Attributes:** _id, name, service-type, identifier, characteristic, <span style='color:red'>active</span> **NHSD Extensions:** openAt, openNow, openIn, serviceProvisionCode, coverageArea.address-postalcode, coverageArea.address-city **Location:** location (as reference), location.address-city, location.address-postalcode, location.address-state, location.near, location.near-distance, location.physicalType, location.address-country **Organization:** organization (as reference), organization.name, organization.identifier, relatedOrganization.identifier **Paging Support:** page, _count **deprecated:** location:Location **NOT SUPPORTED** specialty | location, organization, endpoint |
|[Practitioner](StructureDefinition-nhsd-practitioner.html#search)| Practitioner Directory Entry | **Basic Attributes:** _id, identifier, name, family, given, <span style='color:red'>active</span> **NHSD Extensions:** specialty (search param to find practitioners based on their registered specialty) **Paging Support:** page, _count ||
|[PractitionerRole](StructureDefinition-nhsd-practitionerrole.html#search)| PractitionerRole Directory Entry | **Basic Attributes:** <span style='color:red'>_id</span>, identifier, specialty **Practitioner:** practitioner (as reference), practitioner.identifier, practitioner.name, practitioner.family, practitioner.given **HealthcareService:** service (as reference), service.identifier **Location:** <span style='color:red'>location</span> (as reference), location.address-city, location.address-postalcode, location.address-state, location.near, location.near-distance **Organization:** <span style='color:red'>organization</span> (as reference), name, organization.identifier **To be deprecated:** healthcareservice:HealthcareService, practitioner:Practitioner **Paging Support:** page, _count | practitioner, endpoint |
|[Location](StructureDefinition-nhsd-location.html)| Location Directory Entry | **Basic Attributes:** location search is limited, mostly supported via reference only <span style='color:red'>_id</span> **Organization:** organization (as reference) Paging Support: no support at this time **deprecated:** managingOrganization:Organization | <span style='color:red'>organization</span> |
|[Endpoint](StructureDefinition-nhsd-endpoint.html)| Endpoint Directory Entry | Only Read by Resource Id is supported. ||
{:.grid}
<span style='color:blue'>The information provided above may not reflect the current FHIR Server behaviour. Attributes which are to be supported, but not yet implemented are marked in RED</span>

#### Inclusion (_include)
* _include parameter supported to the extent described in above table.

#### Pagination parameters:
* _count parameter to limit the result count as requested by client consumers.
* page parameter to retrieve the resources starting from a particular page and can be used along with _count.
* Bundle.link is supported as SELF, NEXT and PREVIOUS

<!-- <span style='color:red'>**IMPORTANT NOTE:** As 09/04/2019, the NHSD FHIR Server does not provide the previous / next relation links due to a technical dependency on the framework. The NHSD is working towards providing this capability in the near future. Should you wish to page to the next - please utilise/issue a subsequent query with the appropriate **page=000** request parameter.:</span> -->
```
<link>
  <relation value="self"/>
  <url value="[base]/HealthcareService?name=Johns Hospital&page=3"/>
</link>
<link>
  <relation value="previous"/>
  <url value="[base]/HealthcareService?name=Johns Hospital&page=2"/>
</link>
<link>
  <relation value="next"/>
  <url value="[base]/HealthcareService?name=Johns Hospital&page=4"/>
</link>
```
As at 06/09/2018 the next and previous options are not supported.

### FHIR Server Capability Statement
NHSD FHIR Server detailed [Capability Statement](https://api.fhir.nhsd.healthdirect.org.au/v4/metadata?_format=json) is found at the following location: https://api.fhir.sba.nhsd.healthdirect.org.au/v4/metadata?_format=json

**Please note the url namespace will be changed in the future to be in-line with the environment and capability being provided.**

Please refer to each individual resource [profile](profiles.html) for a comprehensive list of examples.
