
{:.no_toc}

<!-- TOC -->

* Do not remove this line (it will not be displayed)
{:toc}

## Introduction
The NHSD offers a FHIR Bulk Export Service, which is a standard interface to provide integration partners access to accurate, comprehensive health services information in the HL7 FHIR format.

Via the NHSD FHIR Bulk Service, integration partners can obtain large NHSD datasets in the FHIR format, supplemented with notification of change (delta)extractsat whatever frequency required (e.g., daily, weekly).Access to the NHSD FHIR Bulk Export Service is available via a licence agreement with Healthdirect Australia, which includes the agreed approved purpose for which access to the data is granted. For further information please contact nhsd@healthdirect.org.au

## Integration Overview
The following sections of this document detail the technical requirements and implementation process for the NHSD FHIR Bulk Export Service, including integration flows and the interfaces that support the required capabilities.

The initial bulk export capabilities available from NHSD is through a subscription model. Within this model, integration partners will submit their bulk export requirements to the NHSD Teamandthe NHSD will generate exports based on these requirements and make them available to the requestor toretrievefrom a secure endpoint, using a unique identifier.

### Supported NHSD FHIR Entities
Bulk data exports are available for any or all of the following entities, which comprise the NHSD FHIR Entity Data Model (Fig. 1).

* Organization
* Location
* Healthcare Service
* Practitioner
* Practitioner Role
* Endpoint


<img alt="NHSD FHIR Entity Data Model" src="NHSD_FHIR_Entity_Data_model.png" style="float:none"/>

## Subscription Model
The NHSD offers a subscription model for integration partners seeking access to the NHSD Bulk Export service. Integration partners are required to submit the request form below, outlining their required query conditions for data exports, to the NHSD Team(see Fig. 2).  

The NHSD team will then prepare the applicable job schedules for the requested query conditions and allocate a unique subscription identifier (ID),which will be provided to the requestor. The subscription ID is the primary ID for integration partners to query their scheduled job status and retrieve the final export artefacts.

The NHSD Team can provide integration partners further information and advice on completing the request form, including the query conditions currently supported.

The scheduled job is capable of producing the following export artefacts:  

* Complete datasetexports (the full dataset available for each NHSD FHIR entity requested).
* Delta dataset exports (the subset of NHSD records that have changed within each entity requested since the last extract was obtained).

### Subscription Model
Request to create a Bulk Export JobIntegration partners should complete their request details using the form below and provide to the NHSD Team. (Fig. 2 FHIR Bulk Export Request Form).

Figure 2 - FHIR Bulk Export Request form
<table class="grid">
  <thead bgcolor="#ddd">
    <tr>
      <th>Query Condition</th>
      <th>Requestor requirements</th>
    </tr>
  </thead>
  <tbody>
    <tr>
	<tr>
      <td>Start date (Optional)</td>
      <td><p>First bulk extract date.</p>
	      <p>Default  - From the time of setup.</p>
	</td>
    </tr>
	<tr>
      <td>Execution time (Optional)</td>
      <td>
	    <p>Extract time (Timezone - Australia/Sydney).</p>
	    <p>Note: Extracts will be produced on/after execution time.</p>
	  </td>
    </tr>
    <td>Full export frequency</td>
      <td>Default - once every 3 months</td>
    </tr>
    <tr>
      <td>Delta export frequency</td>
      <td>Default – daily</td>
    </tr>
    <tr>
      <td>Entities</td>
      <td>Required entities - <ul>
        <li>Healthcare service</li>
        <li>Location</li>
        <li>Organization</li>
        <li>Practitioner</li>
        <li>Practitioner Role</li>
        <li>Endpoint</li></ul>	
      </td>
    </tr>
    <tr>
      <td>Status</td>
      <td>Required status - <ul>
        <li>Active</li>
        <li>Inactive</li>
        <li>Archived</li></ul>
      </td>
    </tr>
    <tr>
      <td>Conditions for data export for each entity</td>
      <td><p>E.g., all Healthcare services in NSW, all Location entities in WA.</p>
        The NHSD Team can advise further on the supported query conditions.
      </td>
    </tr>
    <tr>
      <td>Requester details</td>
      <td><p>Contact Name:</p>
        <p>Organisation:</p>
        <p>Department:</p>
        <p>Role:</p>
        <p>Email:</p>
        <p>Phone:</p>
        <p>Website:</p>
       </td>
    </tr>
  </tbody>
</table>

### Subscription Model High-level Steps

<img alt="Subscription Model" src="Subscription_model.png" style="float:none"/>

### Process to create Jobs
Note that Job creation and scheduling is currently a NHSD internal process.The NHSD team will prepare the applicable job schedules for the requested query conditions and issueanunique subscription identifier (ID)to the requestor. The subscription ID is used to query thescheduled job status and retrieve the final export artefacts.

Example Subscription and Job requests are as below.

**Sample Subscription:**
```
{"subscriptionId": "sample-nhsd-allExports-subscription","subscriptionStatus": "ACTIVE","fullExportFrequency": 7889400000,"subscriptionType": "FD","createdTime": "2021-10-08T00:00:00Z","deltaExportFrequency": 86400000,"subscriberName": "nhsd Subscriptions","updatedTime": "2021-10-08T00:00:00Z"}
```
**Sample Job:**
```
{"jobId": "nhsd-ORG-only-job","deltaExtractTime": "2022-01-13T22:45:34.034Z","subscriptionId": "sample-nhsd-allExports-subscription","jobDetails": ["{\"entity\":\"ORGANISATION\",\"explicitlyDeniedGroups\":[\"nhsd:identityGroup:HEALTH_INTEGRATOR_LIMITED\"],\"identifiersCriteria\":{\"relatedOrganisationsCriteria\":[{\"query\":\"1000810\",\"type\":\"nhsd:/reference/common/organisationIdentifierType/heroEstablishmentId\"}]},\"filtersCriteria\":{\"status\":[\"ACTIVE\",\"INACTIVE\"]},\"responseControl\":{\"limit\":5}}"],"jobStatus": "ACTIVE","createdTime": "2021-10-08T00:00:00.000Z","updatedTime": "2021-10-08T00:00:00.000Z","fullExtractTime": "2021-12-06T23:57:18.510Z"}
```

### Querying Job Status 
The Job status endpoint is a secure endpoint which requires OAuth Credentials and API key to access the job statuses.

#### Job Status query URL

<table class="grid">
  <tbody>
    <tr>
      <td>Domain</td>
      <td>https://api.fhir.nhsd.healthdirect.org.au/v4</td>
    </tr>
    <tr>
      <td>Endpoint </td>
      <td>/_BulkStatusRequest?Id=&lt;subscription_id&gt;</td>
    </tr>
    <tr>
      <td>Header</td>
      <td>
        <ul>
            <li>Bearer token</li>
            <li>x-api-key</li>
        </ul>
    </td>
    </tr>
    <tr>
      <td>Sample URL</td>
      <td><b>V4 endpoint:</b><br/> https://api.fhir.nhsd.healthdirect.org.au/v4/_BulkStatusRequest?Id=<b>sample-nhsd-allExports-subscription</b>
      </td>
    </tr>
  </tbody>
</table>

#### Job Status Response
The Job status response attributes are per below:
<table class="grid">
  <tbody>
    <tr>
      <td>transactionTime</td>
      <td></td>
      <td>Job execution date and time in UTC</td>
    </tr>
    <tr>
      <td>request</td>
      <td></td>
      <td>Value = subscribedRequest indicates subscribed job requests</td>
    </tr>
    <tr>
      <td>requiresAccessToken</td>
      <td></td>
      <td>Value= true</td>
    </tr>
    <tr>
      <td>accessTokenType</td>
      <td></td>
      <td>Value = presigned, indicates pre-signed access is required.</td>
    </tr>
    <tr>
      <td>output</td>
      <td>        
        <ul>
            <li>type</li>
            <li>url</li>
        </ul>
     </td>
      <td>
        <ul>
            <li>type: type indicates entity</li>
            <li>URL: Signed URL to download the artefacts.</li>
            <b><br/>Note:</b> The URL is valid for 8 hours and includes Active and Inactive resources
        </ul>
        </td>
    </tr>
    <tr>
      <td>error </td>
      <td>
        <ul>
            <li>type</li>
            <li>url</li>
        </ul>
     </td>
      <td>Resources of specific entity resulted in error.</td>
    </tr>
    <tr>
      <td>deleted </td>
      <td>
        <ul>
            <li>type</li>
            <li>url</li>
        </ul>
     </td>
      <td>Archived (deleted) resources of specific entity.</td>
    </tr>
    <tr>
      <td>extension</td>
      <td>
        <ul>
            <li>url</li>
            <li>value</li>
        </ul>
     </td>
      <td>
        <ul>
            <li>Includes the optional FHIR extension to indicate the additional artefacts are available to export.</li>
            <li>Includes the FHIR extension to indicate the URL to re-export the artefact.</li>
            <li>Includes the FHIR extension to indicate the job status.</li>
        </ul>
    </td>
    </tr>
  </tbody>
</table>

#### Sample Job Status payload
```
{"transactionTime":"2022-01-12T23:25:53.434+00:00","request":"subscribedRequest","requiresAccessToken":true,"accessTokenType":"presigned","output":[{"type":"HealthcareService","url":"https://api.fhir.sba.nhsd.healthdirect.org.au/artefacts/test-error-scenario-subscription-job:01122022232553413/HealthcareService/0001.HealthcareService.ndjson?Expires=1642059131&Signature=QI9MNsGdDMYVziP2zxr1uGG-hU5rfkjvuRXqpxzmhQMcA2BR6oxyNaad5iSSJKsQn5c-u9ZdQw9thgIQbsDEW-ajjqFiK0FP57CqPCVb0K3ohuXcRWm9ILUgAHB532w~tEhRSpgLbjl9uTK~HKG5fXcrztwIoFd13-AhQRJEjazXISeQhut5GL02MI96zUcKnmSoOR9m8D3dfcRkPPGqYxGoJOzVI6wUcU05yMy8Ld1bgnnyZern3AYc43d1yY1ScOMO0BFZ4e1k4TNQ9dg2pSBcKon3VSVn3xhS7N2ozeu9T8J6n6vAbpv9umeb0afC6y8Rg6njd8WI2JU0-tiA1A__&Key-Pair-Id=K3A1VIJ4IS73VE"}],"error":[{"type":"OperationOutcome","url":"https://api.fhir.sba.nhsd.healthdirect.org.au/artefacts/test-error-scenario-subscription-job:01122022232553413/HealthcareService/ProcessingError.0001.HealthcareService.ndjson?Expires=1642059131&Signature=CLYy2e-Xcyx1k~tgWReb~RhDZvBKeJ63JxVlFW8YyCa-T04ysL8ZPFpSmGUiF4LhVY4JY4KoufvswxTBiH6KAsDLbOVaqSX8aZu7q8RlRsOPCJvd7H-k6YOMJ2aqKVqMVz6fLNvVRmyUNIcZNI~mkS-SJuckYBJPnbL2sxJG~Cz3fTmkTKcsOv0Tjug0Rm7-FuwHjyPbZcdRk9-VO4tGWj-dLi7lPMG6XxFoVzOKjmgcY271D-KzKmFKOBTrumBDeq9LV6anh5IeyJfPR0kt9wl2J36-PHxmINVTD0923KVhAjE1KKLNEocagRgh-icK-uwJjcFLicsEQosoh99duA__&Key-Pair-Id=K3A1VIJ4IS73VE"}],"deleted":[{"type":"Organization","url":"https://api.fhir.sba.nhsd.healthdirect.org.au/artefacts/test-error-scenario-subscription-job:01122022232553413/Organization/Archived.0001.Organization.ndjson?Expires=1642059131&Signature=a6SbKFQZIVEsS2C6S68d8C8xBStZPmMk6Yw~5TclFRZIMuvgfOdk-4NyQfiG6awGiSHlPLhUFw5x6gmwjCiM6v3RjmBCPrvf0nKkOi~z~s3EF5TFhjTmzwlhk7lObmxvfAUJ6aWpMJ5d02RZ162Z3ZmYjQ7ISm6Zh5U~qL5AWfm10NhiMW-K-RvjZzjFG-4SBqJwn1t58iiaZcN6mx7YauSDAoTB0X4WNNY~66iwhSoNM0GGDvz58O4SeFOZjyla8XncueGXixFS5aQwG1a-xZwz6~Fn2i4ow2IuKJdAQqMj2JzbPa-clJ7zBaZ2f6MwHWYFo200-p49MiPE708B6w__&Key-Pair-Id=K3A1VIJ4IS73VE"}],"extension":[{"url":"http://fhir.nhsd.com.au/BulkExport/bulkExportStatus","value":"EXPORTED"},{"url":"http://fhir.nhsd.com.au/BulkExport/resourceLink","value":"https://api.fhir.sba.nhsd.healthdirect.org.au/v4/_BulkStatusRequest?Id=test-error-scenario-subscription&jobId=test-error-scenario-subscription-job:01122022232553413"}]}
```

#### Sample final Healthcare Service artefacts
```
{"resourceType":"HealthcareService","id":"add65ff6-dee1-7f3d-2a6e-da321b541edc","meta":{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/operationalStatus","extension":[{"url":"current-status","valueString":"OPEN"}]}],"lastUpdated":"2019-08-19T17:29:54.000+00:00"},"identifier":[{"type":{"coding":[{"system":"http://hl7.org.au/fhir/v2/0203","code":"VDI","display":"Vendor Directory Identifier"}],"text":"NHSD Ext URI - Legacy"},"system":"http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers#nhsdExtUri","value":"urn:x-nhsd.au:serv:23024188;33031176","assigner":{"display":"National Health Services Directory"}},{"type":{"coding":[{"system":"http://hl7.org.au/fhir/v2/0203","code":"VDI","display":"Vendor Directory Identifier"}],"text":"NHSD Site Service ID - Legacy"},"system":"http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers#ssid","value":"300236966","assigner":{"display":"National Health Services Directory"}},{"type":{"coding":[{"code":"NHSDURI","display":"NHSD Resource ID"}],"text":"NHSD Healthcare service Resource Identifier"},"system":"http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers#rid","value":"add65ff6-dee1-7f3d-2a6e-da321b541edc"}],"active":true,"providedBy":{"id":"26023210-30b5-da44-d2a4-f4270de6e6bf","reference":"Organization/26023210-30b5-da44-d2a4-f4270de6e6bf","display":"Associate Professor G J Morgan"},"type":[{"coding":[{"system":"nhsd:/reference/taxonomies/snomed-servicetype","code":"310156009","display":"General surgical service"}]},{"coding":[{"system":"http://snomed.info/sct","code":"310156009","display":"General surgical service"}]}],"location":[{"id":"90492c41-28e9-144c-d260-a787b20c6002","reference":"Location/90492c41-28e9-144c-d260-a787b20c6002","display":"Associate Professor G J Morgan"}],"name":"Associate Professor G J Morgan","comment":"thyroid/parathyroid surgery, surgery of salivary glands, advanced and metastatic non-melanoma skin cancer of the head & neck, mucosal cancers of the head & neck, surgery for tumours of the teeth and jaws, miscellaneous conditions of the head & neck.","telecom":[{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/au-contact-purpose","valueCoding":{"system":"http://hl7.org/fhir/contactentity-type","code":"ADMIN"}}],"system":"email","value":"info@profmorgan.com.au","use":"work"},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/au-contact-purpose","valueCoding":{"system":"http://hl7.org/fhir/contactentity-type","code":"ADMIN"}}],"system":"phone","value":"02 9635 6699","use":"work","rank":1},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/au-contact-purpose","valueCoding":{"system":"http://hl7.org/fhir/contactentity-type","code":"ADMIN"}}],"system":"fax","value":"02 9635 6163","use":"work"}],"serviceProvisionCode":[{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-value","valueString":"yes"}],"coding":[{"system":"http://hl7.org.au/fhir/CodeSystem/service-provision-conditions","code":"FAP","display":"Fees Apply"}]}],"characteristic":[{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-group","valueString":"appointments"},{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-value","valueString":"yes"}],"coding":[{"system":"http://fhir.nhsd.com.au/CodeSystem/rc-appointment","code":"yes","display":"Yes"}]},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-group","valueString":"fundingSources"},{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-value","valueString":"yes"}],"coding":[{"system":"http://fhir.nhsd.com.au/CodeSystem/rc-fundingSource","code":"private","display":"Private"}]},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-group","valueString":"facilities"},{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-value","valueString":"yes"}],"coding":[{"system":"http://fhir.nhsd.com.au/CodeSystem/rc-facility","code":"accessibleFriendlyToilet","display":"Accessible Toilet"}]},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-group","valueString":"facilities"},{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-value","valueString":"yes"}],"coding":[{"system":"http://fhir.nhsd.com.au/CodeSystem/rc-facility","code":"toilet","display":"Toilet"}]},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-group","valueString":"facilities"},{"url":"http://fhir.nhsd.com.au/StructureDefinition/characteristic-value","valueString":"yes"}],"coding":[{"system":"http://fhir.nhsd.com.au/CodeSystem/rc-facility","code":"wheelchairAccess","display":"Wheelchair Access"}]}],"availableTime":[{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/availability-specificDate","valueString":"1900-01-01"},{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"daysOfWeek":["mon","tue","wed","thu","fri"],"availableStartTime":"08:30:00","availableEndTime":"17:00:00"}],"notAvailable":[{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Australia Day","during":{"start":"2022-01-25T13:00:00+00:00","end":"2022-01-26T12:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Boxing Day","during":{"start":"2022-12-25T13:00:00+00:00","end":"2022-12-26T12:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Christmas Day","during":{"start":"2022-12-24T13:00:00+00:00","end":"2022-12-25T12:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Easter Monday","during":{"start":"2022-04-17T14:00:00+00:00","end":"2022-04-18T13:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Easter Saturday","during":{"start":"2022-04-15T14:00:00+00:00","end":"2022-04-16T13:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Easter Sunday","during":{"start":"2022-04-16T14:00:00+00:00","end":"2022-04-17T13:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Good Friday","during":{"start":"2022-04-14T14:00:00+00:00","end":"2022-04-15T13:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"New Year's Day","during":{"start":"2021-12-31T13:00:00+00:00","end":"2022-01-01T12:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Anzac Day","during":{"start":"2022-04-24T14:00:00+00:00","end":"2022-04-25T13:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Labour Day - NSW","during":{"start":"2022-10-02T13:00:00+00:00","end":"2022-10-03T12:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"Queen's Birthday - NSW","during":{"start":"2022-06-12T14:00:00+00:00","end":"2022-06-13T13:59:00+00:00"}},{"extension":[{"url":"http://fhir.nhsd.com.au/StructureDefinition/timezone","valueString":"Australia/Sydney"}],"description":"New Year's Day Additional Day","during":{"start":"2022-01-02T13:00:00+00:00","end":"2022-01-03T12:59:00+00:00"}}]}
```

#### No artefacts - Sample Job Status payload
A payload with the NOT_FOUND status code will be returned when no additional artifacts are available for export.

```
{
    "resourceType": "OperationOutcome",
    "issue": [
        {
            "severity": "INFORMATION",
            "code": "TRANSIENT",
            "diagnostics": "No Job statuses are found."
        }
    ]
}
```