
----------

|Operation|Format|Example|
|---|---|---|
|<b>Read</b>|GET [base]/PractitionerRole/[id] |GET [base]/PractitionerRole/bd9fb7ed-3a80-4951-90a4-cb2ef4e815b7|
|<b>search</b>|POST [base]/PractitionerRole/_search||
{:.grid}
{:.grid}

<span style='color:red'>**IMPORTANT NOTES ON SEARCH BEHAVIOUR**</span>
```
NHSD recommends search using POST with for complex search scenarios.
```
For further information and examples, refer to the [capability statement](capstatements.html)

-----------

**Read: PractitionerRole**

Read identified practitioner role resource content.

```
GET [base]/PractitionerRole/[id]

Example: 
GET [base]/PractitionerRole/fad482ad-be24-4b5c-8262-a40c8b4e23ca
```

*Support:*

* Support read PractitionerRole

*Implementation Notes:*

-----------

**Search by Provider Practitioner Name**

Chained search (via Practitioner) based on family, given and/or any name.
Chained search (via Practitioner) based on family, given and/or any name.

```
GET [base]/PractitionerRole?practitioner.family=[string]
GET [base]/PractitionerRole?practitioner.family=[string]&practitioner.given=[string]
GET [base]/PractitionerRole?practitioner.name=[string]

Example:
GET [base]/PractitionerRole?practitioner.family=Jones
GET [base]/PractitionerRole?practitioner.family=Jones&practitioner.given=David
GET [base]/PractitionerRole?practitioner.name=Mario
```

*Support:*

* Search by Practitioner family, given and name.
* Does not support partial or starts with searches.

*Implementation Notes:*

-----------
**Search by Provider Specialty**
Search based on specialty code.

```
GET [base]/PractitionerRole?specialty=[system]|[code]

Example: 
GET [base]/PractitionerRole?specialty=http://snomed.info/sct|1028291000168104
```

*Support:*

* Search PractitionerRole by specialty.

<!---
   TAL-3833 - Remove this example for identifier search by hpio until legal advise that NHSD can publish this information

*Implementation Notes:*
-----------

**Search by Organisation of Provider HPI-O**

Chained search (via Organisation) based on identifier token.

```
GET [base]/PractitionerRole?organization.identifier=[system]|[value]

Example: 
GET [base]/PractitionerRole?organization.identifier=http://business.gov.au/abn|28974283660
```
*Support:*

* Support search by HPI-O.
--->

*Implementation Notes:*

-----------

**Search: Provider Number**
Search based on identifier.

```
GET [base]/PractitionerRole?identifier=[system]|[value]

Example: 
GET [base]/PractitionerRole?identifier=http://ns.electronichealth.net.au/id/medicare-provider-number|4609743J
```

*Support:*

* Support search PractitionerRole by Provider Number.

*Implementation Notes:*

-----------
**Search by Healthcare Service Resource Id**

Search all the practitioner roles in an healthcare service based on Healthcare Service resource Id.

```
GET [base]/PractitionerRole?service={resourceId}

Example: 
GET [base]/PractitionerRole?service=2badb483-f304-0be7-dde1-89fd2bd8f64e
```

*Support:*

* Support search PractitionerRole by Healthcare Service Resource Id.

*Implementation Notes:*

-----------
**Search by Practitioner Resource Id**

Search all the practitioner roles of a Practitioner using practitioner resource id.

```
GET [base]/PractitionerRole?practitioner:Practitioner={resourceId}

Example:
GET [base]/PractitionerRole?practitioner:Practitioner=0647db81-219a-0259-982c-7cb944f1604d
```

*Support:*

* Support search PractitionerRole by Practitioner Resource Id.

*Implementation Notes:*

-----------
**Search by Location Address Parts**

Chained search (via Location) based on address parts for postcode, suburb, and state.

```
GET [base]/PractitionerRole?location.address-postalcode=[postcode]
GET [base]/PractitionerRole?location.address-postalcode=[postcode],[postcode]
GET [base]/PractitionerRole?location.address-postalcode=[postcode],[postcode],[postcode] etc
GET [base]/PractitionerRole?location.address-city=[suburb]
GET [base]/PractitionerRole?location.address-state=[state]

Example: 

GET [base]/PractitionerRole?location.address-postalcode=3996
GET [base]/PractitionerRole?location.address-postalcode=3996,3075
GET [base]/PractitionerRole?location.address-city=INVERLOCH
GET [base]/PractitionerRole?location.address-state=VIC
```

*Support:*

* Search PractitionerRole by location address parts address-postalcode, address-city, address-state.

*Implementation Notes:*

-----------
**Search by Location Distance**

Chained search (via Location) for a Practitioner role in locations within a nominated distance.

```
GET [base]/PractitionerRole?location.near=[latitude]:[longitude]&location.near-distance=[prefix][value]|[units-system]|[units]

Example:

GET [base]/PractitionerRole?location.near=-37.67481995:145.0154266&location.near-distance=10.0|http://unitsofmeasure.org|m
GET [base]/PractitionerRole?location.near=-37.67481995:145.0154266&location.near-distance=10.0|http://unitsofmeasure.org|km
```

*Support:* Search PractitionerRole by location within a distance.
* [value] is a decimal quantity number
* [units-system] fixed 'http://unitsofmeasure.org' identifies standard distance units are used
* [units] distance units must support 'km' or 'm'

*Implementation Notes:*

-----------
**Search: Include References**

The [_include](http://hl7.org/fhir/search.html#include) argument allows the automatic inclusion of referenced resources in the response for a search; based on search parameters defined for this resource type.
```
Example:
GET [base]/PractitionerRole?location.address-postalcode=3996&_include=PractitionerRole:service&_include=PractitionerRole:location&_include=PractitionerRole:organization&_include=PractitionerRole:endpoint 
```
-----------
-----------
**Search By characteristic and Include referenced Practitioner resource**

```
GET [base]/PractitionerRole?characteristic=[system]|[code]&location.near=[latitude]:[longitude]&location.near-distance=[prefix][value]|[units-system]|[units]&_include=PractitionerRole:practitioner

Example:
GET [base]/PractitionerRole?characteristic=http://hl7.org.au/fhir/CodeSystem/service-provision-conditions|FAP&location.near=-37.67481995:145.0154266&location.near-distance=10.0|http://unitsofmeasure.org|m&_include=PractitionerRole:practitioner
GET [base]/PractitionerRole?characteristic=http://hl7.org.au/fhir/CodeSystem/service-provision-conditions|FAP&location.near=-37.67481995:145.0154266&location.near-distance=10.0|http://unitsofmeasure.org|km&_include=PractitionerRole:practitioner
```

-----------
**Search by Combination Search**

Search Practitioner Role with practitioner name and locations with in a given distance at which a service is provided.

```
GET [base]/PractitionerRole?practitioner.name=[name]&location.near=[latitude]:[longitude]&location.near-distance=[prefix][value]|[units-system]|[units]

Example: GET [base]/PractitionerRole?practitioner.name=Brown&location.near=-37.67481995:145.0154266&location.near-distance=10.0|http://unitsofmeasure.org|m
```

*Support:*
* Search PractitionerRole using combination of practitioner name, speciality and location.
* Search PractitionerRole using combination of practitioner identifier (PVN), speciality and location.

-----------

-----------
**Search by Healthcare Service identifier**

```
GET [base]/PractitionerRole?service.identifier=[system]|[code]&_include=PractitionerRole:service

Example: GET [base]/PractitionerRole?service.identifier=http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers#ssid|30000000000&_include=PractitionerRole:service
```
-----------

-----------
**Search by Healthcare Service name**

```
GET [base]/PractitionerRole?service.name=[name]&_include=PractitionerRole:service

Example: GET [base]/PractitionerRole?service.name=Coopers Brewery Original Pale Ale&_include=PractitionerRole:service
```
-----------

-----------
**Search by Healthcare Service type**	

```
GET [base]/PractitionerRole?service.service-type=[system]|[code]&_include=PractitionerRole:service

Example: GET [base]/PractitionerRole?service.service-type=nhsd:/reference/taxonomies/snomed-servicetype|700232004&_include=PractitionerRole:service
```
-----------

-----------
**Search by calendar** Search based on Calendar for service open now and open at a specific date and time.	

```
GET [base]/PractitionerRole?service.openNow=[true]&_include=PractitionerRole:service
GET [base]/PractitionerRole?service.openAt=[Date (yyyy-MM-dd'T'HH:mm:ssXXX)]
GET [base]/PractitionerRole?openIn=[Number in minutes]


Example:
GET [base]/PractitionerRole?service.openNow=true&_include=PractitionerRole:service
GET [base]/PractitionerRole?service.openAt=2017-09-16T14:30:00+10:00
GET [base]/PractitionerRole?service.openIn=30&_include=PractitionerRole:service
GET [base]/PractitionerRole?service.name=Coopers Brewery Original Pale Ale&service.openAt=2025-12-25T12:00:00+10:00&_include=PractitionerRole:service
```
-----------

-----------
**Search by Coverage** Provides the ability to search Practitioner roles providing healthcare Services in a limited area (the coverage area).	
The coverage area is normally associated with Phone Line services (Virtual) or Home treatment services (Home Visit).

```

Example:
GET [base]/PractitionerRole?location.physicalType=virtual&service.coverageArea.address-postalcode=2000&_include=PractitionerRole:location&_include=PractitionerRole:service
GET [base]/PractitionerRole?location.physicalType=home&service.coverageArea.address-postalcode=7000&_include=PractitionerRole:location&_include=PractitionerRole:service
GET [base]/PractitionerRole?location.physicalType=home&service.coverageArea.address-city=Hobart&service.coverageArea.address-postalcode=7000&_include=PractitionerRole:location&_include=PractitionerRole:service

```
-----------

-----------
**Search by Healthcare Service characteristic**

```
GET [base]/PractitionerRole?characteristic=[system]|[code]

Example:
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-facility|parkingFree&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://hl7.org.au/fhir/CodeSystem/service-provision-conditions|FAP&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-program|pirPartnersInRecoveryProgram&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-referralInformation|forPublicUse&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-availability|available&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=nhsd:/reference/common/language|es&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-providerLocationServiceCharacteristic|myHealthRecord&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-offering|explanationOfPaymentOptions&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-eligibility|age-olderAdults65&_include=PractitionerRole:service
GET [base]/PractitionerRole?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-fundingSource|publicFederal&_include=PractitionerRole:service

```
-----------

-----------
**Search Practitioner Role by language**

```
GET [base]/PractitionerRole/_search?languages=[value]

Example:
GET [base]/PractitionerRole/_search?languages=nhsd:/reference/common/language/tiw,nhsd:/reference/common/language/en

```
-----------

-----------
**Search by Practitioner Role by code**

```
GET [base]/PractitionerRole/_search?code=[value]

Example:
GET [base]/PractitionerRole/_search?code=http://snomed.info/sct|11911009
```
-----------

**Pagination**

* NHSD supports paging using page and _count param to fetch Practitioner Role resources. By default the count is 10.

```
GET [base]/PractitionerRole?_format=json&page=1&_count=10
```
Refer to the [capability statement](capstatements.html) for further details on paging support through Bundle.Links

 [(how to search by reference)]: http://hl7.org/fhir/search.html#reference
 [(how to search by token)]: http://hl7.org/fhir/search.html#token
 [(how to search by date)]: http://hl7.org/fhir/search.html#date
 [(how to search by string)]: http://hl7.org/fhir/search.html#string
 [(how to search by quantity)]: http://hl7.org/fhir/search.html#quantity
 [(how to read resource)]: http://hl7.org/fhir/http.html#read