
----------

|Operation|Format|Example|
|---|---|---|
|<b>Read</b>|GET [base]/Practitioner/[id] |GET [base]/Practitioner/bd9fb7ed-3a80-4951-90a4-cb2ef4e815b7|
|<b>search</b>|POST [base]/Practitioner/_search||
{:.grid}

<span style='color:red'>**IMPORTANT NOTES ON SEARCH BEHAVIOUR**</span>
```
NHSD recommends search using POST with for complex search scenarios.
```
For further information and examples, refer to the [capability statement](capstatements.html)

-----------

**Read: Practitioner**

Read identified practitioner resource content.

```
GET [base]/Practitioner/[id]

Example: 
GET [base]/Practitioner/bd9fb7ed-3a80-4951-90a4-cb2ef4e815b7
```

*Support:* Read Practitioner

*Implementation Notes:*

-----------
**Search by Practitioner Name**

Search based on family, given and/or any name.

```
GET [base]/Practitioner?family=[string]
GET [base]/Practitioner?family=[string]&given=[string]
GET [base]/Practitioner?name=[string]

Example:

GET [base]/Practitioner?family=Phillip
GET [base]/Practitioner?family=Phillip&given=David
GET [base]/Practitioner?name=Brown
```

*Support:* Search by family, given and name.

<!---
   TAL-3833 - Remove this example for identifier search by hpii until legal advise that NHSD can publish this information

*Implementation Notes:*

-----------
**Search by HPI-I**

Search based on identifier token.
 
```
GET [base]/Practitioner?identifier=[system]|[value]

Example: GET [base]/Practitioner?identifier=http://ns.electronichealth.net.au/id/hi/hpii/1.0|8003610833334085

```
*Support:* Search by HPI-I.

-->

*Implementation Notes:*

-----------

**Pagination**

* NHSD supports paging using page and _count param to fetch Practitioner resources. By default the count is 10.

```
GET [base]/Practitioner?_format=json&page=1&_count=10
```

Refer to the [capability statement](capstatements.html) for further details on paging support through Bundle.Links

 [(how to search by reference)]: http://hl7.org/fhir/search.html#reference
 [(how to search by token)]: http://hl7.org/fhir/search.html#token
 [(how to search by date)]: http://hl7.org/fhir/search.html#date
 [(how to search by string)]: http://hl7.org/fhir/search.html#string
 [(how to search by quantity)]: http://hl7.org/fhir/search.html#quantity
 [(how to read resource)]: http://hl7.org/fhir/http.html#read