
----------

|Operation|Format|Example|
|---|---|---|
|<b>Read</b>|GET [base]/PractitionerRole/[id] |GET [base]/PractitionerRole/36259758-30f5-83f2-53a8-45891c0ddab0|
|<b>search</b>|POST [base]/PractitionerRole/_search||
{:.grid}

<span style='color:red'>**IMPORTANT NOTES ON SEARCH BEHAVIOUR**</span>
```
NHSD recommends search using POST with for complex search scenarios.
```
For further information and examples, refer to the [capability statement](capstatements.html)

-----------

**Read: Organisation**

Read identified organisation resource content.

```
GET [base]/Organization/[id]

Example: 
GET [base]/Organization/36259758-30f5-83f2-53a8-45891c0ddab0
```
*Implementation Notes:*

-----------
<!---
   TAL-3833 - Remove this example for identifier search by hpio until legal advise that NHSD can publish this information

**Search by HPI-O and other identifiers**
-->

**Search by identifiers**
Search based on identifier token.

```
GET [base]/Organization?identifier=[system]|[value]
```

Example:

<!---
* HPI-O Search
 ```
 GET [base]/Organization?identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003627500000328
 ```
-->

* ABN Search
```
 GET [base]/Organization/?identifier=http://hl7.org.au/id/abn|67164776714
 ```

 * NHSD SITE-ID
 ```
 GET [base]/Organization?identifier=http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers#siteId|202029
```

*Implementation Notes:*

-----------
**Search by Name**
Search based on Organisation Name.

```
GET [base]/Organization?name=[name]

Example: 
GET [base]/Organization?name=Inverloch Chiro
 ```

 -----------
**Pagination**

* NHSD supports paging using page and _count param to fetch Organization resources. By default the count is 10.

```
GET [base]/Organization?_format=json&page=1&_count=10
```

Refer to the [capability statement](capstatements.html) for further details on paging support through Bundle.Links



 [(how to search by reference)]: http://hl7.org/fhir/search.html#reference
 [(how to search by token)]: http://hl7.org/fhir/search.html#token
 [(how to search by date)]: http://hl7.org/fhir/search.html#date
 [(how to search by string)]: http://hl7.org/fhir/search.html#string
 [(how to search by quantity)]: http://hl7.org/fhir/search.html#quantity
 [(how to read resource)]: http://hl7.org/fhir/http.html#read
