
The NHSD FHIR Server does not support complete search behaviours on the Location resource.

All search behaviours on the location is on chained support through HealthcareService and PractitionerRole.

-----------
**Read: Location**

Read identified location resource content.
```
GET [base]/Location/[id]

Example:
GET [base]/Location/bf379d2b-4546-451d-8e1b-fa34ea7ce60e
```

Support GET with references VIA search
```
GET [base]/Location?_id=[id]

Example:
GET [base]/Location?_id=9680fa57-554e-68a1-839a-63d44e501802
```

-----------
**Search: Location**

Search locations managed by an organization using the organisation id. 

NHSD FHIR API supports only search location by the managing organization Id . It does not support searching location by any other attributes.
```
GET [base]/Location?organization=[organizationId] 

Example:  
GET [base]/Location?organization=b3693cd9-56ec-efe2-cbe7-5056099f0d1a
```
------------
**Healthcare Service and Location Types:**

The NHSD FHIR Server contains three distinct types of Healthcare Services, relating to both the Location and the Healthcare Service delivery type.

|Location Delivery Type|Code|Description|Parameter|
|---|---|---|---|
|Area| area |Defines an area or coverage, primarily utilised within the context of a HealthcareService to specify the coverageArea. Coverage is defined in Suburb(s) OR State(s) OR Country (AUS)|n/a|
|Physical Service| si |A Physical location, where the patient is able to visit a room or building|location.physicalType=si|
|Home Visit|home|A Home Visit based location grouping, where all the Healthcare Services linked to this Location are considered HOME VISIT services. These are predominantly services such as Home Meal Services, Home Doctor Services, but not strictly limited thereto. Distance based search behaviours are not compatible with this Location Delivery Type|location.physicalType=home|
|Virtual|virtual|A Virtual or Online based location grouping, where all the Healthcare Services linked to this Location are considered VIRTUAL services. These may include, but not limited to websites, online help lines, emergency services, etc.  Distance based search behaviours are not compatible with this Location Delivery Type|location.physicalType=virtual|
{:.grid}


**Search: Location Delivery Method**
```
- SITE VISIT    => [base]/HealthcareService?location.physicalType=si
- PHONE/VIRTUAL => [base]/HealthcareService?location.physicalType=virtual
- HOME          => [base]/HealthcareService?location.physicalType=home
```
-----------


 [(how to search by reference)]: http://hl7.org/fhir/search.html#reference
 [(how to search by token)]: http://hl7.org/fhir/search.html#token
 [(how to search by date)]: http://hl7.org/fhir/search.html#date
 [(how to search by string)]: http://hl7.org/fhir/search.html#string
 [(how to search by quantity)]: http://hl7.org/fhir/search.html#quantity
 [(how to read resource)]: http://hl7.org/fhir/http.html#read