-----


|Operation|Format|Example|
|---|---|---|
|<b>Read</b>|GET [base]/HealthcareService/[id] |GET [base]/HealthcareService/9680fa57-554e-68a1-839a-63d44e501802|
|<b>search</b>|POST [base]/HealthcareService/_search||
{:.grid}

<span style='color:red'>**IMPORTANT NOTES ON SEARCH BEHAVIOUR**</span>
```
NHSD recommends search using POST with for complex search scenarios.
```
For further information and examples, refer to the [capability statement](capstatements.html)

-----------

**Extended Characteristic Value Sample**

For some of the characteristics within a Healthcare Service there are additional information that pertains to the coding. These may be notes or values (noted as a characteristic-value OR a characteristic-extendedValues)
**Please note that these extensions shall be incorporated into AU-BASE profile(s) - this the Extension URI will change (this not was added on 3 october 2018)**

The extensions define information as follows:

* `http://fhir.nhsd.com.au/StructureDefinition/characteristic-group` - a grouping to support User Interfaces or other program logic.

* `http://fhir.nhsd.com.au/StructureDefinition/characteristic-value` - a simplistic value that determines if/whether the characteristic applies or not (eg. Bulk Billing = no, or Free Parking = yes)

* `http://fhir.nhsd.com.au/StructureDefinition/characteristic-extendedValues` - a complex extension that provides additional information, which at this time only supports a "note"
```
{
    "characteristic": [{
        "extension": [{
            "url": "http://fhir.nhsd.com.au/StructureDefinition/characteristic-group",
            "valueString": "referralInformation"
        },
        {
            "url": "http://fhir.nhsd.com.au/StructureDefinition/characteristic-value",
            "valueString": "yes"
        },
        {
            "url": "http://fhir.nhsd.com.au/StructureDefinition/characteristic-extendedValues",
            "extension": [{
                "url": "note",
                "valueString": "Service accepts self referral"
            }]
        }],
        "coding": [{
            "system": "http://fhir.nhsd.com.au/CodeSystem/rc-referralInformation",
            "code": "forPublicUse",
            "display": "For Public Use"
        }]
    }
}
```

**Healthcare Service and Location Types:**

The NHSD FHIR Server contains three distinct types of Healthcare Services, relating to both the Location and the Healthcare Service delivery type.

|Location Delivery Type|Code|Description|Parameter|
|---|---|---|---|
|Physical Service| si |A Physical location, where the patient is able to visit a room or building|location.physicalType=si|
|Home Visit|home|A Home Visit based location grouping, where all the Healthcare Services linked to this Location are considered HOME VISIT services. These are predominantly services such as Home Meal Services, Home Doctor Services, but not strictly limited thereto. Distance based search behaviours are not compatible with this Location Delivery Type|location.physicalType=home|
|Virtual|virtual|A Virtual or Online based location grouping, where all the Healthcare Services linked to this Location are considered VIRTUAL services. These may include, but not limited to websites, online help lines, emergency services, etc.  Distance based search behaviours are not compatible with this Location Delivery Type|location.physicalType=virtual|
{:.grid}

-----------

### Read: HealthcareService

**Read by Resource Id** Read identified healthcare service resource content.
```
GET [base]/HealthcareService/[id]
Example: GET [base]/HealthcareService/9680fa57-554e-68a1-839a-63d44e501802
```

**Read resource using resource Id and Include references**
```
GET [base]/HealthcareService?_id=[id]&_include=HealthcareService:location&_include=HealthcareService:organization
Example: GET [base]/HealthcareService?_id=9680fa57-554e-68a1-839a-63d44e501802&_include=HealthcareService:location&_include=HealthcareService:organization
```
*Support:*
* NHSD support read a Healthcare service by id

*Implementation Notes:*

### Search: Healthcare Services

***Search by Location Delivery Method***
   Search for a healthcare service by Location Delivery Method.
```
- SITE VISIT    => [base]/HealthcareService?location.physicalType=si
- PHONE/VIRTUAL => [base]/HealthcareService?location.physicalType=virtual
- HOME          => [base]/HealthcareService?location.physicalType=home
```

------------
***Search by Name***
Search for a healthcare service by name.
```
GET [base]/HealthcareService?name=[string]

Example: 
GET [base]/HealthcareService?name=bishops%20bridge%20Community%20Health
GET [base]/HealthcareService?name=Lismore Base Hospital clinic
```
*Support:*
* Search by HealthcareService name.

*Implementation Notes:*

-----------
***Search by Identifiers***
   Search for a healthcare service by an identifier.

<!---
    TAL-3833 - Remove this example for identifier search by hpio until legal advise that NHSD can publish this information

GET [base]/HealthcareService?_format=json&identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003624900017424)
-->

```
GET [base]/HealthcareService?name=[string]&identifier=[system]|[code]

Example:

GET [base]/HealthcareService?identifier=http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers#ssid|169459
GET [base]/HealthcareService?identifier=http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers%23ssid|169459
```

*Support:* NHSD FHIR Server support search Healthcare Service by identifier. With the primary identifiers being:

<!---
* HPI-O
-->

* Electronic ID's

*Implementation Notes:*


-----------
**Search by Healthcare Service Type**
Search for a Healthcare Service based on the TYPE of service it provides or offers. A "General Practitioner Service" or "Dentist Service".
```
GET [base]/HealthcareService?service-type=[system]|[code]

Example:
GET [base]/HealthcareService?service-type=nhsd:/reference/taxonomies/snomed-servicetype|1223091000168105
```

*Support:*
* Supports search HealthcareService by type classification.
* Single Token and Multi-Token (OR) is supported
  * Multi-Token is to be implemented in September 2018
  * `GET GET [base]/HealthcareService?service-type=nhsd:/reference/taxonomies/snomed-servicetype|1223091000168105,nhsd:/reference/taxonomies/snomed-servicetype|1255941000168103`

*Not Supported*
* NHSD does not support TEXT based search on the codesystem labels
* NHSD does not support HealthcareService.specialty search

*Implementation Notes:*

-----------
**Search by Service Provision Code**
Search based on service provision code token. 
```
GET [base]/HealthcareService?serviceProvisionCode=[system]|[value]

Example: GET [base]/HealthcareService/?serviceProvisionCode=http://hl7.org/fhir/service-provision-conditions|free
```
*Support:*
* Support search by serviceProvisionCode.

*Implementation Notes:*

-----------
**Search by Location Address Parts**
Chained search (via Location) based on address parts for postcode, suburb, and state.
```
GET [base]/HealthcareService?location.address-postalcode=[postcode]
GET [base]/HealthcareService?location.address-city=[suburb]
GET [base]/HealthcareService?location.address-state=[state]

Example: 
GET [base]/HealthcareService?location.address-postalcode=2328
GET [base]/HealthcareService?location.address-city=Denman
GET [base]/HealthcareService?location.address-state=NSW
```

*Support:*
* NHSD support search by multiple postcode, suburb and state but it will return results matching all the postcode, suburb and state. The results are not filtered with the relationship across the parameters.
* Support basic **param=[string]** search which is case and accent-insensitive search;  field equals or starts with the string value. Please refer to the example below for multiple param search.

```
Example:
GET [base]/HealthcareService?_format=json&location.address-city=Denman,NORTH%20SYDNEY&_include=HealthcareService:location
GET [base]/HealthcareService?_format=json&_include=HealthcareService:organization
```
-----------
**Search by Location Distance**
Chained search (via Location) for a location within a nominated distance.
```
GET [base]/HealthcareService?location.near=[latitude]:[longitude]&location.near-distance=[prefix][value]|[units-system]|[units]

Example:
GET [base]/HealthcareService?location.near=-32.81:151.43&location.near-distance=le4000|http://unitsofmeasure.org|km
```
*Support:*
* [prefix] fixed 'le' is less than or equal to distance
* [value] is a decimal quantity number
* [units-system] fixed 'http://unitsofmeasure.org' identifies standard distance units are used
* [units] distance units must support 'km' or 'm'

*Implementation Notes:*

-----------
**Search by Coverage**
Provides the ability to search Healthcare Services which operate or provide care in a limited area (the coverage area).

The coverage area is normally associated with Phone Line services (Virtual) or Home treatment services (Home Visit).
```
Example:
GET [base]/HealthcareService?coverageArea.address-postalcode=2000&location.physicalType=home
GET [base]/HealthcareService?coverageArea.address-postalcode=2000&location.physicalType=virtual
GET [base]/HealthcareService?location.physicalType=virtual,home&coverageArea.address-postalcode=6042&coverageArea.address-city=SEABIRD
```
*Support:*

Coverage Area search is currently only supported with the following attributes:
* address-postalcode only 
* combination of address-postalcode and address-city

-----------
**Search By calendar**
 Search based on Calendar for service open now and open at a specific date an time.
```
GET [base]/HealthcareService?openNow=[true/false]
GET [base]/HealthcareService?openAt=[Date (yyyy-MM-dd'T'HH:mm:ssXXX)]
GET [base]/HealthcareService?openIn=[Number in minutes]

Example:
GET [base]/HealthcareService?openNow=true
GET [base]/HealthcareService?openAt=2017-09-16T14:30:00+10:00
GET [base]/HealthcareService?openIn=30
```

*Support:*
* Support search for a health care service with the other search criteria along withe below calendar criteria.
* openNow - List of services that are open now 
* openAt - List of services that are open at a specific date 
* openIn - List of servcies that are open in minutes.

```
Example:
GET [base]/HealthcareService?_format=json&service-type=nhsd:/reference/taxonomies/snomed-servicetype|1223091000168105&openNow=true
```
-----------
**Search By characteristic**
```
GET [base]/HealthcareService?characteristic=[system]|[code]
```

NHSD supports search based on Healthcare Service characteristics. For example:
* find a Healthcare Service which operates under the nPeP Program
* find a Healthcare Service which offers wheelchair access.

Multiple characteristics search patterns are also supported. In multiple characteristics scenario called composite search parameters.

**AND Search Param** 

For example, the result of the search operation is the intersection of the resources that match the criteria specified by each individual search parameter. If a parameter repeats, such as 

```
/HealthcareService?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-facility|wheelchairAccess&characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-facility|hearingInductionLoop
```

then this matches healthcare services which has both Wheelchair Access and Hearing Induction Loop as location facilities. This is known as an AND search parameter, since the server is expected to respond only with results which match both values.

**OR Search Param** 

If, instead, the search is to find Healthcare Service that has either facility type, then this is a single parameter with multiple values, separated by a ,. 

For example, 
```
/HealthcareService?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-facility|wheelchairAccess,http://fhir.nhsd.com.au/CodeSystem/rc-facility|hearingInductionLoop
```

This is known as an OR search parameter, since the server is expected to respond with results which match either value.

**Example: Search By characteristic**
* Single Characteristic search

```
GET [base]/HealthcareService?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-program|npepProgram
GET [base]/HealthcareService?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-program|npepProgram&service-type=nhsd:/reference/taxonomies/snomed-servicetype|1223091000168105
GET [base]/HealthcareService?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-appointment|yes
GET [base]/HealthcareService?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-eligibility|age-olderAdults65
```

* **OR** Characteristic search

```
 GET [base]/HealthcareService?characteristic=http://fhir.nhsd.com.au/CodeSystem/rc-program|npepProgram,http://fhir.nhsd.com.au/CodeSystem/rc-program|dayProgram
```

* **AND** Characteristic search:

This query is recommended to be performed as a POST-method call, depending on the expected size of the query. Refer to the [capability statement](capstatements.html) for more details.

```
POST /v4/HealthcareService/_search HTTP/1.1
Host: api.fhir.nhsd.healthdirect.org.au
x-api-key: {API KEY AS PROVIDED BY NHSD}
Cache-Control: no-cache
Content-Type: application/x-www-form-urlencoded
_count=5&characteristic=http%3A%2F%2Ffhir.nhsd.com.au%2FCodeSystem%2Frc-program%7CnpepProgram&characteristic=http%3A%2F%2Ffhir.nhsd.com.au%2FCodeSystem%2Frc-providerLocationServiceCharacteristic%7CmyHealthRecord
```

*Implementation Notes:*

-----------

<span style='color:red'>**Service Providing Organization**</span>
Service Providing Organization represents the organisation directly linked to location and provides the actual healthcare service.

<span style='color:red'>**Related Organization**</span>
In hierarchical multi level organization setup, the Related Organization represents the organization above the service providing organization with part_of relationship.

NHSD supports the healthcare service search based on attributes of service providing organizatins and related organization identifiers

**Search Healthcare Service based on the name of the Organization (Service providing Organization)**

Chained search (via Organisation) based on text name.


```
GET [base]/HealthcareService?organization.name=[string]

Example: GET [base]/HealthcareService?organization.name=GP%20SURGERY
```
*Support:*
* Refer to [NHSD Organization](StructureDefinition-nhsd-organisation.html).

Refer to the [capability statement](capstatements.html) for additional detail on chained search support.

-----------

**Search Healthcare Service based on an identifier of the Organization (Service providing Organization)**

Chained search (via Organisation) based on identifier token.

```
GET [base]/HealthcareService?organization.identifier=[system]|[code]
```

Example:

<!---
   TAL-3833 - Remove this example for identifier search by hpio until legal advise that NHSD can publish this information

* HPI-O Search
```
 GET [base]/HealthcareService?organization.identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003627500000328
```
-->

* ABN search
 ```
 GET [base]/HealthcareService/?organization.identifier=http://hl7.org.au/id/abn|67164776714
 ```

 * NHSD SITE-ID search
 ```
    GET [base]/HealthcareService?organization.identifier=http://fhir.nhsd.com.au/CodeSystem/nhsdIdentifiers#siteId|202029
```

*Support:*
* Refer to [NHSD Organization](StructureDefinition-nhsd-organisation.html) for details on identifier support for an Organization.

Refer to the [capability statement](capstatements.html) for additional detail on chained search support.


-----------

**Search Healthcare Service based on an identifier of the related Organization**

Chained search (via related Organisation) based on identifier token.

```
GET [base]/HealthcareService?relatedOrganization.identifier=[system]|[code]
```

* 2 levels of organization (a related organization and a service providing organization)
```
 GET [base]/HealthcareService/_search?relatedOrganization.identifier=nhsd:/reference/common/organisationIdentifierType/heroEstablishmentId|12341243
```

* 3 levels of organization (2 levels of related organization and a service providing organization)
```
 GET [base]/HealthcareService/_search?relatedOrganization.identifier=nhsd:/reference/common/organisationIdentifierType/heroEstablishmentId|12341243&relatedOrganization.identifier=nhsd:/reference/common/organisationIdentifierType/heroEstablishmentId|219033
```

* Combination of related organizations and service providing organizations
```
 GET [base]/HealthcareService/_search?relatedOrganization.identifier=nhsd:/reference/common/organisationIdentifierType/heroEstablishmentId|12341243&relatedOrganization.identifier=nhsd:/reference/common/organisationIdentifierType/heroEstablishmentId|219033&organization.identifier=nhsd:/reference/common/organisatio nIdentifierType/heroEstablishmentId|21800034
```
-----------

**Search By Reference**

A reference parameter refers to references between resources. For example, find all HealthcareServices where the subject reference is a particular Location, where the location is selected by resource id. 

```
GET [base]/HealthcareService?location=54c462a-ce75-11e7-abc4-cec278b6b50a
GET [base]/HealthcareService?organization=54c462a-ce75-11e7-abc4-cec278b6b50a
```
*Implementation Notes:*


-----------
**Search: Include References**

The [_include](http://hl7.org/fhir/search.html#include) argument allows the automatic inclusion of referenced resources in the response for a search; based on search parameters defined for this resource type.
```
 Example:
 GET [base]/HealthcareService?name=St%20Johns&_include=HealthcareService:location
 GET [base]/HealthcareService?name=St%20Johns&_include=HealthcareService:organization
 GET [base]/HealthcareService?name=St%20Johns&_include=HealthcareService:endpoint 
 GET [base]/HealthcareService?name=St%20Johns&_include=HealthcareService:organization&_include=HealthcareService:location&_include=HealthcareService:endpoint
```
-----------
**Search: Combination**

* Searches with a single request using logical AND for criteria. e.g specialty cardiologist in post code 4846.
* Please refer to the [capability statement](capstatements.html) for additional detail on chained search support.

Locate a Healthcare Service (a Pharmacy) as a physical service (si) within a 5Km radius from a known GEO-point (and postcode 3000) that is open now.
```
[base]/HealthcareService?_count=20&location.near=-37.81:144.96&location.address-postalcode=3000&location.near-distance=5000.0|http://unitsofmeasure.org|m&location.physicalType=si&service-type=nhsd:/reference/taxonomies/snomed-servicetype|1223091000168105&openNow=true
```

-----------

**Pagination**

* NHSD supports paging using page and _count param to fetch Healthcare Service resources. By default the count is 10.
```
GET [base]/HealthcareService?_format=json&page=1&_count=10
```

Refer to the [capability statement](capstatements.html) for further details on paging support through Bundle.Links



 [(how to search by reference)]: http://hl7.org/fhir/search.html#reference
 [(how to search by token)]: http://hl7.org/fhir/search.html#token
 [(how to search by date)]: http://hl7.org/fhir/search.html#date
 [(how to search by string)]: http://hl7.org/fhir/search.html#string
 [(how to search by quantity)]: http://hl7.org/fhir/search.html#quantity
 [(how to read resource)]: http://hl7.org/fhir/http.html#read
